<?php 
require $_SERVER['DOCUMENT_ROOT'] . '/adminprotect.php';
// delivery-fees.php
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard</title>
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    html, body {
      width: 100%; height: 100%;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f5f7fa;
      color: #333;
    }
    a { text-decoration: none; color: inherit; }
    .top-bar {
      background-color: #2c3e50;
      color: #ecf0f1;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0.75rem 1.5rem;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .top-bar-left { font-size: 1.25rem; font-weight: 600; }
    .top-bar-left a { color: #ecf0f1; }
    .top-bar-right {
      font-size: 0.95rem;
      display: flex;
      align-items: center;
      gap: 1rem;
    }
    .top-bar-right a.logout {
      color: #ecf0f1;
      font-weight: 500;
      border: 1px solid #ecf0f1;
      padding: 0.3rem 0.8rem;
      border-radius: 4px;
      transition: background-color 0.2s;
    }
    .top-bar-right a.logout:hover { background-color: #34495e; }
    .main-layout {
      display: flex;
      min-height: calc(100vh - 56px);
      width: 100%;
    }
    .side-nav {
      width: 220px;
      background-color: #ecf0f1;
      padding: 1rem 0;
      border-right: 1px solid #dfe4ea;
    }
    .side-nav h3 {
      margin: 0 1rem 1rem;
      font-size: 1rem;
      color: #2c3e50;
      font-weight: 600;
    }
    .nav-item { margin-bottom: 0.5rem; }
    .nav-heading {
      cursor: pointer;
      padding: 0.75rem 1rem;
      display: block;
      color: #2c3e50;
      font-weight: 500;
    }
    .nav-heading:hover { background-color: #dfe4ea; }
    .sub-menu {
      display: none;
      list-style: none;
      padding: 0; margin: 0;
    }
    .sub-menu li a {
      display: block;
      padding: 0.5rem 2rem;
      color: #2c3e50;
      font-size: 0.9rem;
    }
    .sub-menu li a:hover { background-color: #dfe4ea; }
    .nav-item.open .sub-menu { display: block; }
    .content-area {
      flex: 1;
      padding: 1.5rem;
      background: #ffffff;
      overflow-x: auto;
    }
    .content-area h1 {
      margin-bottom: 1rem;
      font-size: 1.5rem;
      font-weight: 600;
      color: #2c3e50;
    }
  </style>
</head>
<body>
<div class="top-bar">
  <div class="top-bar-left">
    <a href="admin_dashboard.php">Bahamas Freight Network</a>
  </div>
  <div class="top-bar-right">
    <span>Admin Dashboard</span>
    <a href="https://fastfoods242.com/adminlogout.php" class="logout">Log Out</a>
  </div>
</div>
<div class="main-layout">
  <div class="side-nav">
    <?php include $_SERVER['DOCUMENT_ROOT'] . '/admin_side_menu.php'; ?>
  </div>
  <main class="content-area">
    <h1>Admin Dashboard</h1>
    <p>This section is the administrator dashboard, which oversees the operations of the site.</p>
  </main>
</div>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var headings = document.querySelectorAll('.nav-heading');
    headings.forEach(function (h) {
      h.addEventListener('click', function () {
        h.parentElement.classList.toggle('open');
      });
    });
  });
</script>
</body>
</html>
