<?php
session_start();
require 'db_connect.php';

$token = $_GET['token'] ?? '';
if (empty($token)) {
    die("No token provided.");
}

// If form was submitted:
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];

    // Basic validation
    if ($newPassword !== $confirmPassword) {
        $error = "Passwords do not match.";
    } else {
        // Check if token is valid (and not expired)
        // *** ADDED: we now select reset_token_created_at
        $sql = "SELECT data_entry_id, reset_token_created_at 
                FROM admin_users
                WHERE reset_token = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows === 1) {
            // we have a valid row
            $row = $result->fetch_assoc();
            $createdAt   = $row['reset_token_created_at'];
            $createdTime = strtotime($createdAt);
            $currentTime = time();
            // 30 minutes = 1800 seconds
            $timeDiff = $currentTime - $createdTime;

            if ($timeDiff > 1800) {
                // Link is too old
                $error = "The reset link has expired. Please request a new link.";
            } else {
                // Token is valid and not expired
                $hashed = password_hash($newPassword, PASSWORD_DEFAULT);

                // Update the user's password and clear the token
                $updateSQL = "UPDATE admin_users 
                              SET password = ?, reset_token = NULL, reset_token_created_at = NULL
                              WHERE reset_token = ?";
                $updateStmt = $conn->prepare($updateSQL);
                $updateStmt->bind_param("ss", $hashed, $token);

                if ($updateStmt->execute()) {
                    $success = "Your password has been reset. You can now log in.";
                } else {
                    $error = "Error updating password. Please try again.";
                }
            }
        } else {
            $error = "Invalid or expired token.";
        }
    }
}

// Close DB
$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Reset Password</title>
    <style>
        /* Match the design from login.php */
        body {
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
        }
        .top-bar {
            background-color: #2c3673;
            color: #fff;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0.5rem 1rem;
        }
        .top-bar-left {
            font-size: 1.2rem;
            font-weight: bold;
        }
        .top-bar-right {
            font-weight: bold;
        }
        .center-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: calc(100vh - 50px);
        }
        .login-box {
            background-color: #fff;
            padding: 2rem;
            border-radius: 4px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
            text-align: center;
            width: 300px;
        }
        .login-box h2 {
            margin-top: 0;
        }
        .theme-button {
            background-color: #f0c20c;
            color: #333;
            border: none;
            padding: 0.6rem 1.2rem;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
        }
        .theme-button:hover {
            background-color: #d9ad0b;
        }
        .error-msg {
            color: red;
        }
        .success-msg {
            color: green;
        }
        .back-link {
            display: inline-block;
            margin-top: 1rem;
            text-decoration: none;
            color: #2c3673;
        }
        .back-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="top-bar">
  <div class="top-bar-left">Carib Clear Administration</div>
  <div class="top-bar-right">Reset Password</div>
</div>

<div class="center-container">
  <div class="login-box">
    <h2>Reset Password</h2>

    <?php if (!empty($error)): ?>
      <p class="error-msg"><?php echo $error; ?></p>
    <?php elseif (!empty($success)): ?>
      <p class="success-msg"><?php echo $success; ?></p>
      <a href="adminlogin.php" class="back-link">Return to Login</a>
    <?php else: ?>
      <form method="post">
        <p>
          New Password:<br>
          <input type="password" name="new_password" required>
        </p>
        <p>
          Confirm Password:<br>
          <input type="password" name="confirm_password" required>
        </p>
        <button type="submit" class="theme-button">Reset</button>
      </form>
    <?php endif; ?>
  </div>
</div>

</body>
</html>
