<?php
session_start();
require 'db_connect.php'; // Ensure this is your database connection file

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $sql = "SELECT data_entry_id, username, password, data_personnel_name 
            FROM admin_users 
            WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            $_SESSION['loggedin'] = true;
            $_SESSION['username'] = $user['username'];
            $_SESSION['data_personnel_name'] = $user['data_personnel_name'];

            header("Location: /admin_dashboard.php");
            exit;
        } else {
            $error = "Invalid username or password.";
        }
    } else {
        $error = "Invalid username or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login</title>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Segoe+UI:400,600&display=swap">
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    html, body {
      width: 100%; height: 100%;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f5f7fa;
    }
    a { text-decoration: none; color: inherit; }
    .top-bar {
      background-color: #2c3e50;
      color: #ecf0f1;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0.75rem 1.5rem;
      box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .top-bar-left {
      font-size: 1.25rem;
      font-weight: 600;
    }
    .top-bar-right {
      font-size: 0.95rem;
      font-weight: 500;
    }
    .center-container {
      display: flex;
      justify-content: center;
      align-items: center;
      height: calc(100vh - 56px);
    }
    .login-box {
      background-color: #fff;
      padding: 2rem;
      border-radius: 4px;
      box-shadow: 0 0 8px rgba(0,0,0,0.1);
      text-align: center;
      width: 320px;
    }
    .login-box h2 {
      margin-bottom: 1rem;
      color: #2c3e50;
    }
    .login-box input[type="text"],
    .login-box input[type="password"] {
      width: 100%;
      padding: 0.6rem;
      margin-bottom: 1rem;
      border: 1px solid #ccc;
      border-radius: 4px;
    }
    .theme-button {
      background-color: #f0c20c;
      color: #333;
      border: none;
      padding: 0.6rem 1.2rem;
      border-radius: 4px;
      cursor: pointer;
      font-weight: bold;
    }
    .theme-button:hover {
      background-color: #d9ad0b;
    }
    .forgot-link {
      display: inline-block;
      margin-top: 1rem;
      text-decoration: none;
      color: #2c3e50;
      font-size: 0.9rem;
    }
    .forgot-link:hover {
      text-decoration: underline;
    }
    .error-msg {
      color: red;
      margin-bottom: 1rem;
    }
  </style>
</head>
<body>
<div class="top-bar">
  <div class="top-bar-left">Bahamas Freight Hub</div>
  <div class="top-bar-right">Sign In</div>
</div>
<div class="center-container">
  <div class="login-box">
    <h2>Login</h2>
    <?php if (isset($error)) echo "<p class='error-msg'>$error</p>"; ?>
    <form method="post">
      <input type="text" name="username" placeholder="Username" required>
      <input type="password" name="password" placeholder="Password" required>
      <button type="submit" class="theme-button">Login</button>
    </form>
    <a class="forgot-link" href="admin_forgetpassword.php">Forgot password?</a>
  </div>
</div>
</body>
</html>
